package calc;

import java.io.*;

public class CalcApp {
  
  public static void main(String[] args) throws IOException{
    
    BufferedReader reader;
    reader = new BufferedReader(new InputStreamReader(System.in));
    
    String line;
    
    while((line = reader.readLine()) != null) {
      CalcTokenizer ct = new CalcTokenizer(line);
      try {
        Expression e = CalcParser.parseExpression(ct);
        e.evaluate();
      } catch(CalcException ce) {
        System.out.println("Syntax Error: " + ce.getMessage());
      }
    }
  }
}
